/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jf.baksmali.AnalysisArguments;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.baksmali.DisassembleCommand;
import org.jf.dexlib2.analysis.CustomInlineMethodResolver;
import org.jf.dexlib2.analysis.InlineMethodResolver;
import org.jf.dexlib2.dexbacked.DexBackedOdexFile;
import org.jf.util.jcommander.ExtendedParameter;
import org.jf.util.jcommander.ExtendedParameters;

@Parameters(commandDescription="Deodexes an odex/oat file")
@ExtendedParameters(commandName="deodex", commandAliases={"de", "x"})
public class DeodexCommand
extends DisassembleCommand {
    @ParametersDelegate
    protected AnalysisArguments.CheckPackagePrivateArgument checkPackagePrivateArgument = new AnalysisArguments.CheckPackagePrivateArgument();
    @Parameter(names={"--inline-table", "--inline", "--it"}, description="Specify a file containing a custom inline method table to use. See the \"deodexerant\" tool in the smali github repository to dump the inline method table from a device that uses dalvik.")
    @ExtendedParameter(argumentNames={"file"})
    private String inlineTable;

    public DeodexCommand(List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    @Override
    protected BaksmaliOptions getOptions() {
        BaksmaliOptions options = super.getOptions();
        options.deodex = true;
        if (this.dexFile instanceof DexBackedOdexFile) {
            if (this.inlineTable == null) {
                options.inlineResolver = InlineMethodResolver.createInlineMethodResolver(((DexBackedOdexFile)this.dexFile).getOdexVersion());
            } else {
                File inlineTableFile = new File(this.inlineTable);
                if (!inlineTableFile.exists()) {
                    System.err.println(String.format("Could not find file: %s", this.inlineTable));
                    System.exit(-1);
                }
                try {
                    options.inlineResolver = new CustomInlineMethodResolver(options.classPath, inlineTableFile);
                }
                catch (IOException ex) {
                    System.err.println(String.format("Error while reading file: %s", inlineTableFile));
                    ex.printStackTrace(System.err);
                    System.exit(-1);
                }
            }
        }
        return options;
    }

    @Override
    protected boolean shouldCheckPackagePrivateAccess() {
        return this.checkPackagePrivateArgument.checkPackagePrivateAccess;
    }

    @Override
    protected boolean needsClassPath() {
        return true;
    }

    @Override
    protected boolean showDeodexWarning() {
        return false;
    }
}

